unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls;

type
    TfrmMain = class(TForm)
    btnCommand: TBitBtn;
    txtXmlData: TRichEdit;
    lblTimeout: TLabel;
    cmbTimeout: TComboBox;
    Label2: TLabel;
    lblPort: TLabel;
    cmbPort: TComboBox;
    chkShowMessage: TCheckBox;
    Label4: TLabel;
    framReceivedXml: TGroupBox;
    btnClear: TBitBtn;
    lblResponse: TLabel;
    txtReceivedXml: TRichEdit;
    lblAffectedAmount: TLabel;
    procedure btnCommandClick(Sender: TObject);
    procedure btnClearClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

uses Math;

{$R *.dfm}
procedure DestroyTTerminalDll(); external 'PC2POS.dll';
procedure TTerminalDllInit(); external 'PC2POS.dll';
procedure TTerminalDllSetPort(PortName:Int64); external 'PC2POS.dll';
procedure TTerminalDllOpenPort(); external 'PC2POS.dll';
procedure TTerminalDllClosePort(); external 'PC2POS.dll';
function TTerminalDllSendToCOM(str:Int64):Boolean; external 'PC2POS.dll';
procedure TTerminalDllSetShowMessages(s:Int64); external 'PC2POS.dll';
procedure TTerminalDllGetXmlRecieve(str:Int64); external 'PC2POS.dll';
procedure TTerminalDllGetXmlRecieveState(str:Int64); external 'PC2POS.dll';
procedure TTerminalDllGetXmlError(str:Int64); external 'PC2POS.dll';
procedure TTerminalDllGetReturnedMessage(str:Int64); external 'PC2POS.dll';
procedure TTerminalDllGetRetPAN(str:Int64); external 'PC2POS.dll';
procedure TTerminalDllGetRetBatchNo(str:Int64); external 'PC2POS.dll';
procedure TTerminalDllGetRetSerialNo(str:Int64); external 'PC2POS.dll';
procedure TTerminalDllGetRetDateTime(str:Int64); external 'PC2POS.dll';
procedure TTerminalDllGetRetTermID(str:Int64); external 'PC2POS.dll';
procedure TTerminalDllGetRetActionCode(str:Int64); external 'PC2POS.dll';
procedure TTerminalDllGetRetResponseCode(str:Int64); external 'PC2POS.dll';
procedure TTerminalDllGetRetRRN(str:Int64); external 'PC2POS.dll';
procedure TTerminalDllGetRetTraceNo(str:Int64); external 'PC2POS.dll';
procedure TTerminalDllGetRetAmount(str:Int64); external 'PC2POS.dll';
procedure TTerminalDllGetRetAffectedAmount(str:Int64); external 'PC2POS.dll';
function TTerminalDllGetConfirmFlag(): Boolean; external 'PC2POS.dll';
function TTerminalDllGetShowMessages(): Boolean; external 'PC2POS.dll';
function TTerminalDllGetPrintFlag():BYTE; external 'PC2POS.dll';
function TTerminalDllGetXmlRecieveSize():Cardinal; external 'PC2POS.dll';
function TTerminalDllGetXmlRecieveStateSize():Cardinal; external 'PC2POS.dll';
function TTerminalDllGetXmlErrorSize():Cardinal; external 'PC2POS.dll';
function TTerminalDllGetReturnedMessageSize():Cardinal; external 'PC2POS.dll';
function TTerminalDllGetRetPANSize():Cardinal; external 'PC2POS.dll';
function TTerminalDllGetRetBatchNoSize():Cardinal; external 'PC2POS.dll';
function TTerminalDllGetRetSerialNoSize():Cardinal; external 'PC2POS.dll';
function TTerminalDllGetRetDateTimeSize():Cardinal; external 'PC2POS.dll';
function TTerminalDllGetRetTermIDSize():Cardinal; external 'PC2POS.dll';
function TTerminalDllGetRetActionCodeSize():Cardinal; external 'PC2POS.dll';
function TTerminalDllGetRetResponseCodeSize():Cardinal; external 'PC2POS.dll';
function TTerminalDllGetRetRRNSize():Cardinal; external 'PC2POS.dll';
function TTerminalDllGetRetTraceNoSize():Cardinal; external 'PC2POS.dll';
function TTerminalDllGetRetAmountSize():Cardinal; external 'PC2POS.dll';
function TTerminalDllGetRetAffectedAmountSize():Cardinal; external 'PC2POS.dll';
procedure TTerminalDllSetLogPath(logPath: Int64); external 'PC2POS.dll';


procedure TfrmMain.btnCommandClick(Sender: TObject);
  var objPtr : Int64;
      intTimeout: Int64;
      strPort : WideString;
      blnSent : Boolean;
      strXml : WideString;
      Size:Int64;
      ErrorSize:Int64;
      StateSize:Int64;
      ResponseSize:Int64;
      AffAmountSize:Int64;
      Counter:Integer;
      sTest:  WideString;
      strResponse: WideString;
      strAffectedAmount: WideString;
      sTestLen:Int64;
      buff: array [0..255] of WideChar;
      s: string;
      bln:Boolean;
      path : WideString;
begin
  strPort := cmbPort.Text;
  intTimeout := StrToInt64(cmbTimeout.Text) * 10;
  btnCommand.Caption := 'Sending';
  strXml := txtXmlData.Lines.Text;
  Size:=0;
  ErrorSize:=0;
  StateSize:=0;
  ResponseSize:=0;
  Counter:=0;

  txtReceivedXml.Clear();
  lblResponse.Caption := 'Response Code:';
  lblAffectedAmount.Caption := 'Affected Amount:';

  TTerminalDllInit();

  path := 'C:\\';
  TTerminalDllSetLogPath(Int64(PWideString(path)));

  TTerminalDllSetPort(Int64(PWideString(strPort)));
  TTerminalDllSetShowMessages(Int64(IfThen(chkShowMessage.Checked,1,0)));
  TTerminalDllOpenPort();
  blnSent := TTerminalDllSendToCOM(Int64(PWideString(strXml)));

  Repeat
    Size := TTerminalDllGetXmlRecieveSize();
    ErrorSize := TTerminalDllGetXmlErrorSize();
    StateSize := TTerminalDllGetXmlRecieveStateSize();
    Inc(Counter);
    Sleep(100);
  Until ((Size <> 0) or (ErrorSize <> 0) or (StateSize <> 0) or (Counter > (intTimeout div 2)));

  If (Counter > (intTimeout div 2)) then
  begin
    MessageDlg('Response Timeout. Please try again.', mtInformation, mbOKCancel, 0);
    TTerminalDllClosePort();
    DestroyTTerminalDll();
    btnCommand.Caption := 'Send';
    Exit;
  end;


  SetLength(sTest, Size);
  TTerminalDllGetXmlRecieve(Int64(PWideString(sTest)));
  txtReceivedXml.Lines.Text := sTest;

  ResponseSize := TTerminalDllGetRetResponseCodeSize();
  AffAmountSize := TTerminalDllGetRetAffectedAmountSize();

  SetLength(strResponse, ResponseSize);
  SetLength(strAffectedAmount, AffAmountSize);

  TTerminalDllGetRetResponseCode(Int64(PWideString(strResponse)));
  TTerminalDllGetRetAffectedAmount(Int64(PWideString(strAffectedAmount)));

  lblResponse.Caption := 'Response Code: ' + strResponse;
  lblAffectedAmount.Caption := 'Affected Amount: ' + strAffectedAmount;

  TTerminalDllClosePort();
  DestroyTTerminalDll();

  btnCommand.Caption := 'Send';
end;


procedure TfrmMain.btnClearClick(Sender: TObject);
begin
  txtReceivedXml.Clear;
  lblResponse.Caption := 'Response Code:';
  lblAffectedAmount.Caption := 'Affected Amount:';
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
    //Filling Port ComboBox
    cmbPort.Clear;
    cmbPort.AddItem('COM1', TObject(1));
    cmbPort.AddItem('COM2', TObject(2));
    cmbPort.AddItem('COM3', TObject(3));
    cmbPort.AddItem('COM4', TObject(4));
    cmbPort.AddItem('COM5', TObject(5));
    cmbPort.AddItem('COM6', TObject(6));
    cmbPort.AddItem('COM7', TObject(7));
    cmbPort.AddItem('COM8', TObject(8));
    cmbPort.AddItem('COM9', TObject(9));
    cmbPort.AddItem('COM10', TObject(10));

    cmbTimeout.ItemIndex:=4;
    cmbPort.ItemIndex:=2;

    txtXmlData.Lines.Text := '<Item1></Item1>'+ #13#10 +
                             '<Value1></Value1>' + #13#10 +
                             '<Printed1>1</Printed1>' + #13#10 +
                             '<Item2> ǘ</Item2>'+ #13#10 +
                             '<Value2>100</Value2>' + #13#10 +
                             '<Printed2>1</Printed2>' + #13#10 +
                             '<Item3></Item3>' + #13#10 +
                             '<Value3>94-02-10</Value3>' + #13#10 +
                             '<Printed3>1</Printed3>' + #13#10 +
                             '<Amount1>200</Amount1>' + #13#10 +
                             '<Amount2>300</Amount2>' + #13#10 +
                             '<Amount3>500</Amount3>' + #13#10 +
                             '<TotalFee>1000</TotalFee>' + #13#10 +
                             '<PrgVer>v2.0.50727</PrgVer>';

end;

end.
